/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class AlloyRecipeSerializer
extends IERecipeSerializer<AlloyRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.ALLOY_SMELTER);
    }

    @Override
    public AlloyRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        Lazy<ItemStack> output = AlloyRecipeSerializer.readOutput(json.get("result"));
        IngredientWithSize input0 = IngredientWithSize.deserialize(json.get("input0"));
        IngredientWithSize input1 = IngredientWithSize.deserialize(json.get("input1"));
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)200);
        return new AlloyRecipe(recipeId, output, input0, input1, time);
    }

    @Nullable
    public AlloyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Lazy<ItemStack> output = AlloyRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input0 = IngredientWithSize.read(buffer);
        IngredientWithSize input1 = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        return new AlloyRecipe(recipeId, output, input0, input1, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, AlloyRecipe recipe) {
        AlloyRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input0.write(buffer);
        recipe.input1.write(buffer);
        buffer.writeInt(recipe.time);
    }
}

